/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.BaseGuildMessageChannel;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.MissingAccessException;
import net.dv8tion.jda.api.managers.channel.concrete.NewsChannelManager;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.Checks;

public interface NewsChannel
extends BaseGuildMessageChannel {
    @Nonnull
    @CheckReturnValue
    public RestAction<Webhook.WebhookReference> follow(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    default public RestAction<Webhook.WebhookReference> follow(long targetChannelId) {
        return this.follow(Long.toUnsignedString(targetChannelId));
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Webhook.WebhookReference> follow(@Nonnull TextChannel targetChannel) {
        Checks.notNull(targetChannel, "Target Channel");
        Member selfMember = targetChannel.getGuild().getSelfMember();
        if (!selfMember.hasAccess(targetChannel)) {
            throw new MissingAccessException(targetChannel, Permission.VIEW_CHANNEL);
        }
        if (!selfMember.hasPermission((GuildChannel)targetChannel, Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(targetChannel, Permission.MANAGE_WEBHOOKS);
        }
        return this.follow(targetChannel.getId());
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Message> crosspostMessageById(@Nonnull String messageId) {
        Checks.isSnowflake(messageId);
        if (!this.getGuild().getSelfMember().hasAccess(this)) {
            throw new MissingAccessException(this, Permission.VIEW_CHANNEL);
        }
        Route.CompiledRoute route = Route.Messages.CROSSPOST_MESSAGE.compile(this.getId(), messageId);
        return new RestActionImpl<Message>(this.getJDA(), route, (response, request) -> request.getJDA().getEntityBuilder().createMessage(response.getObject(), this, false));
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Message> crosspostMessageById(long messageId) {
        return this.crosspostMessageById(Long.toUnsignedString(messageId));
    }

    @Nonnull
    public ChannelAction<NewsChannel> createCopy(@Nonnull Guild var1);

    @Nonnull
    default public ChannelAction<NewsChannel> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Override
    @Nonnull
    public NewsChannelManager getManager();
}

