/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import java.util.LinkedList;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.events.message.MessageEmbedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.ReceivedMessage;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;

public class MessageUpdateHandler
extends SocketHandler {
    public MessageUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        boolean isGuild;
        boolean bl = isGuild = !content.isNull("guild_id");
        if (isGuild) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        if (content.hasKey("author")) {
            if (content.hasKey("type")) {
                MessageType type = MessageType.fromId(content.getInt("type"));
                if (!type.isSystem()) {
                    return this.handleMessage(content, isGuild);
                }
                WebSocketClient.LOG.debug("JDA received a message update for an unexpected message type. Type: {} JSON: {}", (Object)type, (Object)content);
                return null;
            }
            if (!content.isNull("embeds")) {
                this.handleMessageEmbed(content);
                return null;
            }
        } else if (!content.isNull("embeds")) {
            return this.handleMessageEmbed(content);
        }
        return null;
    }

    private Long handleMessage(DataObject content, boolean isGuild) {
        ReceivedMessage message;
        try {
            message = isGuild ? this.getJDA().getEntityBuilder().createMessageGuildChannel(content, true) : this.getJDA().getEntityBuilder().createMessagePrivateChannel(content, true);
        }
        catch (IllegalArgumentException e) {
            switch (e.getMessage()) {
                case "MISSING_CHANNEL": {
                    long channelId = content.getLong("channel_id");
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("Received a message update for a channel that JDA does not currently have cached");
                    return null;
                }
                case "MISSING_USER": {
                    long authorId = content.getObject("author").getLong("id");
                    this.getJDA().getEventCache().cache(EventCache.Type.USER, authorId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("Received a message update for a user that JDA does not currently have cached");
                    return null;
                }
            }
            throw e;
        }
        if (message.getChannelType() == ChannelType.PRIVATE) {
            this.getJDA().usedPrivateChannel(message.getChannel().getIdLong());
        }
        this.getJDA().handleEvent(new MessageUpdateEvent(this.getJDA(), this.responseNumber, message));
        return null;
    }

    private Long handleMessageEmbed(DataObject content) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        long messageId = content.getLong("id");
        long channelId = content.getLong("channel_id");
        LinkedList<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
        MessageChannel channel = (MessageChannel)this.getJDA().getTextChannelsView().get(channelId);
        if (channel == null) {
            channel = this.getJDA().getNewsChannelById(channelId);
        }
        if (channel == null) {
            channel = (MessageChannel)this.getJDA().getPrivateChannelsView().get(channelId);
        }
        if (channel == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received message update for embeds for a channel/group that JDA does not have cached yet.");
            return null;
        }
        DataArray embedsJson = content.getArray("embeds");
        for (int i = 0; i < embedsJson.length(); ++i) {
            embeds.add(builder.createMessageEmbed(embedsJson.getObject(i)));
        }
        this.getJDA().handleEvent(new MessageEmbedEvent(this.getJDA(), this.responseNumber, messageId, channel, embeds));
        return null;
    }
}

