/*
 * Decompiled with CFR 0.152.
 */
package za.co.knonchalant.candogram;

import java.util.List;
import za.co.knonchalant.candogram.IBotAPI;
import za.co.knonchalant.candogram.handlers.IInlineHandler;
import za.co.knonchalant.candogram.handlers.IMessageHandler;
import za.co.knonchalant.candogram.handlers.IUpdate;

public class Bots {
    private final String name;
    private List<IBotAPI> apis;
    private List<IMessageHandler> handlers;
    private IInlineHandler inlineHandler;

    public Bots(String name, List<IBotAPI> apis, List<IMessageHandler> handlers) {
        this(name, apis, handlers, null);
    }

    public Bots(String name, List<IBotAPI> apis, List<IMessageHandler> handlers, IInlineHandler inlineHandler) {
        this.apis = apis;
        this.name = name;
        this.handlers = handlers;
        this.inlineHandler = inlineHandler;
        for (IBotAPI api : apis) {
            api.addHandlers(handlers);
            api.setInlineHandler(inlineHandler);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<IBotAPI> getApis() {
        return this.apis;
    }

    public List<IMessageHandler> getHandlers() {
        return this.handlers;
    }

    public IInlineHandler getInlineHandler() {
        return this.inlineHandler;
    }

    public void send(long chatId, String message) {
        for (IBotAPI api : this.apis) {
            api.sendMessage(chatId, message, null, true, null, null);
        }
    }

    public void sendPhoto(IUpdate chatId, byte[] file) {
        for (IBotAPI api : this.apis) {
            api.sendPhoto(chatId, file);
        }
    }

    public String toString() {
        return "Bots{name='" + this.name + '\'' + '}';
    }
}

