/*
 * Decompiled with CFR 0.152.
 */
package zm.hashcode.rafiki;

import java.io.File;
import java.time.Duration;
import java.util.Objects;
import org.testcontainers.containers.ComposeContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class RafikiCompose
implements AutoCloseable {
    private final ComposeContainer compose = new ComposeContainer(new File[]{new File(Objects.requireNonNull(this.getClass().getClassLoader().getResource("rafiki/docker-compose.yml"), "docker-compose.yml not found in classpath").getFile())}).withLocalCompose(true).withExposedService("rafiki-backend-1", 3000, Wait.forListeningPort().withStartupTimeout(Duration.ofMinutes(3L))).withExposedService("rafiki-backend-1", 3001, Wait.forListeningPort().withStartupTimeout(Duration.ofMinutes(3L))).withExposedService("rafiki-backend-1", 3002, Wait.forListeningPort().withStartupTimeout(Duration.ofMinutes(3L)));

    public void start() {
        this.compose.start();
    }

    public void stop() {
        this.compose.stop();
    }

    public String backendOpenPaymentsUrl() {
        return this.getServiceUrl("rafiki-backend-1", 3000);
    }

    public String backendAdminUrl() {
        return this.getServiceUrl("rafiki-backend-1", 3001);
    }

    public String backendConnectorUrl() {
        return this.getServiceUrl("rafiki-backend-1", 3002);
    }

    @Deprecated
    public String authServerUrl() {
        return this.getServiceUrl("rafiki-auth-1", 3006);
    }

    @Deprecated
    public String frontendUrl() {
        return this.getServiceUrl("rafiki-frontend-1", 3005);
    }

    private String getServiceUrl(String serviceName, int port) {
        try {
            int mappedPort = this.compose.getServicePort(serviceName, Integer.valueOf(port));
            return "http://localhost:" + mappedPort;
        }
        catch (IllegalStateException e) {
            return "http://localhost:" + port + " (not started)";
        }
    }

    @Override
    public void close() {
        this.stop();
    }
}

